/*
 * Decompiled with CFR 0.152.
 */
package com.mizo0203.twitter.timeline.talker;

import com.mizo0203.twitter.timeline.talker.Talker;
import com.mizo0203.twitter.timeline.talker.UrlUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import twitter4j.Paging;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.Configuration;

public class TwitterTimelineTalker {
    public static final String LANG_JA = Locale.JAPAN.getLanguage();
    private final RequestHomeTimelineTimerTask mRequestHomeTimelineTimerTask;

    public TwitterTimelineTalker(Configuration configuration, Talker talker) {
        Twitter twitter = new TwitterFactory(configuration).getInstance();
        this.mRequestHomeTimelineTimerTask = new RequestHomeTimelineTimerTask(twitter, talker);
    }

    static String getUserNameWithoutContext(String name) {
        Pattern p = Pattern.compile("([^@\uff20]+).*");
        Matcher m = p.matcher(name);
        return m.replaceFirst("$1");
    }

    public void start() {
        new Timer().schedule((TimerTask)this.mRequestHomeTimelineTimerTask, 0L, TimeUnit.MINUTES.toMillis(1L));
    }

    private static class RequestHomeTimelineTimerTask
    extends TimerTask {
        private static final int HOME_TIMELINE_COUNT_MAX = 200;
        private static final int HOME_TIMELINE_COUNT_MIN = 1;
        private final Twitter mTwitter;
        private final Talker mTalker;
        private Talker.YukkuriVoice mYukkuriVoice = Talker.YukkuriVoice.REIMU;
        private long mStatusSinceId = 1L;
        private boolean mIsUpdatedStatusSinceId = false;

        private RequestHomeTimelineTimerTask(Twitter twitter, Talker talker) {
            this.mTwitter = twitter;
            this.mTalker = talker;
        }

        @Override
        public void run() {
            try {
                int count = this.mIsUpdatedStatusSinceId ? 200 : 1;
                Paging paging = new Paging(1, count, this.mStatusSinceId);
                ResponseList<Status> statusResponseList = this.mTwitter.getHomeTimeline(paging);
                if (statusResponseList.isEmpty()) {
                    return;
                }
                this.mStatusSinceId = ((Status)statusResponseList.get(0)).getId();
                this.mIsUpdatedStatusSinceId = true;
                Collections.reverse(statusResponseList);
                for (Status status : statusResponseList) {
                    this.onStatus(status);
                }
            }
            catch (TwitterException e) {
                e.printStackTrace();
            }
        }

        private void onStatus(Status status) {
            if (!LANG_JA.equalsIgnoreCase(status.getLang())) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            if (status.isRetweet()) {
                Status retweetedStatus = status.getRetweetedStatus();
                buffer.append(TwitterTimelineTalker.getUserNameWithoutContext(status.getUser().getName()) + "\u3055\u3093\u304c\u30ea\u30c4\u30a4\u30fc\u30c8\u3002");
                buffer.append(TwitterTimelineTalker.getUserNameWithoutContext(retweetedStatus.getUser().getName()) + "\u3055\u3093\u304b\u3089\u3001");
                buffer.append(retweetedStatus.getText());
            } else {
                buffer.append(TwitterTimelineTalker.getUserNameWithoutContext(status.getUser().getName()) + "\u3055\u3093\u304b\u3089\u3001");
                buffer.append(status.getText());
            }
            this.mTalker.talkAsync(UrlUtil.convURLEmpty(buffer).replaceAll("\n", "\u3002"), this.mYukkuriVoice);
            this.mYukkuriVoice = this.mYukkuriVoice == Talker.YukkuriVoice.REIMU ? Talker.YukkuriVoice.MARISA : Talker.YukkuriVoice.REIMU;
        }
    }
}

