/*
 * Decompiled with CFR 0.152.
 */
package com.sys1yagi.mastodon4j.api;

import com.sys1yagi.mastodon4j.api.Dispatcher;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/sys1yagi/mastodon4j/api/Dispatcher;", "", "()V", "executorService", "Ljava/util/concurrent/ExecutorService;", "getExecutorService", "()Ljava/util/concurrent/ExecutorService;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "shutdownTime", "", "getShutdownTime", "()J", "invokeLater", "", "task", "Ljava/lang/Runnable;", "shutdown", "mastodon4j"})
public final class Dispatcher {
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final ReentrantLock lock;
    private final long shutdownTime = 1000L;

    @NotNull
    public final ExecutorService getExecutorService() {
        return this.executorService;
    }

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    public final long getShutdownTime() {
        return this.shutdownTime;
    }

    public final void invokeLater(@NotNull Runnable task) {
        Intrinsics.checkParameterIsNotNull(task, "task");
        this.executorService.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.executorService.shutdown();
            if (!this.executorService.awaitTermination(this.shutdownTime, TimeUnit.MILLISECONDS)) {
                this.executorService.shutdownNow();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public Dispatcher() {
        ExecutorService executorService2 = Executors.newFixedThreadPool(1, executorService.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(executorService2, "Executors.newFixedThread\u2026dThreadPool thread\n    })");
        this.executorService = executorService2;
        this.lock = new ReentrantLock();
        this.shutdownTime = 1000L;
    }
}

