/*
 * Decompiled with CFR 0.152.
 */
package com.sys1yagi.mastodon4j;

import com.google.gson.Gson;
import com.sys1yagi.mastodon4j.Parameter;
import com.sys1yagi.mastodon4j.api.exception.Mastodon4jRequestException;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0002\u001f B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u001c\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/sys1yagi/mastodon4j/MastodonClient;", "", "instanceName", "", "client", "Lokhttp3/OkHttpClient;", "gson", "Lcom/google/gson/Gson;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;Lcom/google/gson/Gson;)V", "baseUrl", "getBaseUrl", "()Ljava/lang/String;", "debug", "", "debugPrint", "", "log", "delete", "Lokhttp3/Response;", "path", "get", "parameter", "Lcom/sys1yagi/mastodon4j/Parameter;", "getInstanceName", "getSerializer", "patch", "body", "Lokhttp3/RequestBody;", "post", "postUrl", "url", "AuthorizationInterceptor", "Builder", "mastodon4j"})
public class MastodonClient {
    private boolean debug;
    @NotNull
    private final String baseUrl;
    private final String instanceName;
    private final OkHttpClient client;
    private final Gson gson;

    public final void debugPrint(@NotNull String log) {
        Intrinsics.checkParameterIsNotNull(log, "log");
        if (this.debug) {
            System.out.println((Object)log);
        }
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public Gson getSerializer() {
        return this.gson;
    }

    @NotNull
    public String getInstanceName() {
        return this.instanceName;
    }

    @NotNull
    public Response get(@NotNull String path, @Nullable Parameter parameter) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        try {
            Object object;
            block5: {
                String url;
                block4: {
                    Parameter parameter2;
                    url = "" + this.baseUrl + '/' + path;
                    this.debugPrint(url);
                    object = parameter;
                    if (object == null) break block4;
                    Parameter it = parameter2 = object;
                    object = "" + url + '?' + it.build();
                    if (object != null) break block5;
                }
                object = url;
            }
            Object urlWithParams = object;
            Call call = this.client.newCall(new Request.Builder().url((String)urlWithParams).get().build());
            Response response = call.execute();
            Intrinsics.checkExpressionValueIsNotNull(response, "call.execute()");
            return response;
        }
        catch (IOException e) {
            throw (Throwable)new Mastodon4jRequestException(e);
        }
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Response get$default(MastodonClient mastodonClient, String string, Parameter parameter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
        }
        if ((n & 2) != 0) {
            parameter = null;
        }
        return mastodonClient.get(string, parameter);
    }

    @NotNull
    public Response postUrl(@NotNull String url, @NotNull RequestBody body) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        Intrinsics.checkParameterIsNotNull(body, "body");
        try {
            this.debugPrint(url);
            Call call = this.client.newCall(new Request.Builder().url(url).post(body).build());
            Response response = call.execute();
            Intrinsics.checkExpressionValueIsNotNull(response, "call.execute()");
            return response;
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new Mastodon4jRequestException(e);
        }
        catch (IOException e) {
            throw (Throwable)new Mastodon4jRequestException(e);
        }
    }

    @NotNull
    public Response post(@NotNull String path, @NotNull RequestBody body) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(body, "body");
        return this.postUrl("" + this.baseUrl + '/' + path, body);
    }

    @NotNull
    public Response patch(@NotNull String path, @NotNull RequestBody body) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(body, "body");
        try {
            String url = "" + this.baseUrl + '/' + path;
            this.debugPrint(url);
            Call call = this.client.newCall(new Request.Builder().url(url).patch(body).build());
            Response response = call.execute();
            Intrinsics.checkExpressionValueIsNotNull(response, "call.execute()");
            return response;
        }
        catch (IOException e) {
            throw (Throwable)new Mastodon4jRequestException(e);
        }
    }

    @NotNull
    public Response delete(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        try {
            String url = "" + this.baseUrl + '/' + path;
            this.debugPrint(url);
            Call call = this.client.newCall(new Request.Builder().url(url).delete().build());
            Response response = call.execute();
            Intrinsics.checkExpressionValueIsNotNull(response, "call.execute()");
            return response;
        }
        catch (IOException e) {
            throw (Throwable)new Mastodon4jRequestException(e);
        }
    }

    private MastodonClient(String instanceName, OkHttpClient client, Gson gson) {
        this.instanceName = instanceName;
        this.client = client;
        this.gson = gson;
        this.baseUrl = "https://" + this.instanceName + "/api/v1";
    }

    public /* synthetic */ MastodonClient(@NotNull String instanceName, @NotNull OkHttpClient client, @NotNull Gson gson, DefaultConstructorMarker $constructor_marker) {
        this(instanceName, client, gson);
    }

    public static final /* synthetic */ boolean access$getDebug$p(MastodonClient $this) {
        return $this.debug;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\n\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/sys1yagi/mastodon4j/MastodonClient$Builder;", "", "instanceName", "", "okHttpClientBuilder", "Lokhttp3/OkHttpClient$Builder;", "gson", "Lcom/google/gson/Gson;", "(Ljava/lang/String;Lokhttp3/OkHttpClient$Builder;Lcom/google/gson/Gson;)V", "accessToken", "debug", "", "build", "Lcom/sys1yagi/mastodon4j/MastodonClient;", "useStreamingApi", "mastodon4j"})
    public static final class Builder {
        private String accessToken;
        private boolean debug;
        private final String instanceName;
        private final OkHttpClient.Builder okHttpClientBuilder;
        private final Gson gson;

        @NotNull
        public final Builder accessToken(@NotNull String accessToken) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(accessToken, "accessToken");
            Builder $receiver = builder = this;
            $receiver.accessToken = accessToken;
            return builder;
        }

        @NotNull
        public final Builder useStreamingApi() {
            Builder builder;
            Builder $receiver = builder = this;
            $receiver.okHttpClientBuilder.readTimeout(60L, TimeUnit.SECONDS);
            return builder;
        }

        @NotNull
        public final Builder debug() {
            Builder builder;
            Builder $receiver = builder = this;
            $receiver.debug = true;
            return builder;
        }

        @NotNull
        public final MastodonClient build() {
            MastodonClient mastodonClient;
            OkHttpClient okHttpClient = this.okHttpClientBuilder.addNetworkInterceptor(new AuthorizationInterceptor(this.accessToken)).build();
            Intrinsics.checkExpressionValueIsNotNull(okHttpClient, "okHttpClientBuilder.addN\u2026tor(accessToken)).build()");
            MastodonClient it = mastodonClient = new MastodonClient(this.instanceName, okHttpClient, this.gson, null);
            it.debug = this.debug;
            return mastodonClient;
        }

        public Builder(@NotNull String instanceName, @NotNull OkHttpClient.Builder okHttpClientBuilder, @NotNull Gson gson) {
            Intrinsics.checkParameterIsNotNull(instanceName, "instanceName");
            Intrinsics.checkParameterIsNotNull(okHttpClientBuilder, "okHttpClientBuilder");
            Intrinsics.checkParameterIsNotNull(gson, "gson");
            this.instanceName = instanceName;
            this.okHttpClientBuilder = okHttpClientBuilder;
            this.gson = gson;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/sys1yagi/mastodon4j/MastodonClient$AuthorizationInterceptor;", "Lokhttp3/Interceptor;", "accessToken", "", "(Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "mastodon4j"})
    private static final class AuthorizationInterceptor
    implements Interceptor {
        @Nullable
        private final String accessToken;

        @Override
        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request.Builder builder;
            Intrinsics.checkParameterIsNotNull(chain, "chain");
            Request originalRequest = chain.request();
            Request.Builder $receiver = builder = originalRequest.newBuilder().headers(originalRequest.headers()).method(originalRequest.method(), originalRequest.body());
            String string = this.accessToken;
            if (string != null) {
                String string2;
                String it = string2 = string;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string3 = "Bearer %s";
                Object[] objectArray = new Object[]{it};
                String string4 = "Authorization";
                Request.Builder builder2 = $receiver;
                String string5 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull(string5, "java.lang.String.format(format, *args)");
                String string6 = string5;
                builder2.header(string4, string6);
            }
            Request compressedRequest = builder.build();
            Response response = chain.proceed(compressedRequest);
            Intrinsics.checkExpressionValueIsNotNull(response, "chain.proceed(compressedRequest)");
            return response;
        }

        @Nullable
        public final String getAccessToken() {
            return this.accessToken;
        }

        public AuthorizationInterceptor(@Nullable String accessToken) {
            this.accessToken = accessToken;
        }

        public /* synthetic */ AuthorizationInterceptor(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        public AuthorizationInterceptor() {
            this(null, 1, null);
        }
    }
}

