/*
 * Decompiled with CFR 0.152.
 */
package com.mizo0203.timeline.talker;

import com.mizo0203.timeline.talker.Talker;
import com.mizo0203.timeline.talker.TimelineTalker;
import com.mizo0203.timeline.talker.util.DisplayNameUtil;
import com.mizo0203.timeline.talker.util.UrlUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import twitter4j.Paging;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.Configuration;

public class TwitterTimelineTalker
implements TimelineTalker {
    private static final String LANG_JA = Locale.JAPAN.getLanguage();
    @NotNull
    private final RequestHomeTimelineTimerTask mRequestHomeTimelineTimerTask;

    public TwitterTimelineTalker(@NotNull Configuration configuration, Talker talker) {
        if (configuration == null) {
            TwitterTimelineTalker.$$$reportNull$$$0(0);
        }
        Twitter twitter = new TwitterFactory(configuration).getInstance();
        this.mRequestHomeTimelineTimerTask = new RequestHomeTimelineTimerTask(twitter, talker);
    }

    @Override
    public void start() {
        new Timer().schedule((TimerTask)this.mRequestHomeTimelineTimerTask, 0L, TimeUnit.MINUTES.toMillis(1L));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/mizo0203/timeline/talker/TwitterTimelineTalker", "<init>"));
    }

    private static class RequestHomeTimelineTimerTask
    extends TimerTask {
        private static final int HOME_TIMELINE_COUNT_MAX = 200;
        private static final int HOME_TIMELINE_COUNT_MIN = 1;
        private final Twitter mTwitter;
        private final Talker mTalker;
        private long mStatusSinceId = 1L;
        private boolean mIsUpdatedStatusSinceId = false;

        private RequestHomeTimelineTimerTask(Twitter twitter, Talker talker) {
            this.mTwitter = twitter;
            this.mTalker = talker;
        }

        @Override
        public void run() {
            try {
                int count = this.mIsUpdatedStatusSinceId ? 200 : 1;
                Paging paging = new Paging(1, count, this.mStatusSinceId);
                ResponseList<Status> statusResponseList = this.mTwitter.getHomeTimeline(paging);
                if (statusResponseList.isEmpty()) {
                    return;
                }
                this.mStatusSinceId = ((Status)statusResponseList.get(0)).getId();
                this.mIsUpdatedStatusSinceId = true;
                Collections.reverse(statusResponseList);
                for (Status status : statusResponseList) {
                    this.onStatus(status);
                }
            }
            catch (TwitterException e) {
                e.printStackTrace();
            }
        }

        private void onStatus(Status status) {
            if (!LANG_JA.equalsIgnoreCase(status.getLang())) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            if (status.isRetweet()) {
                Status retweetedStatus = status.getRetweetedStatus();
                buffer.append(DisplayNameUtil.removeContext(status.getUser().getName())).append("\u3055\u3093\u304c\u30ea\u30c4\u30a4\u30fc\u30c8\u3002");
                buffer.append(DisplayNameUtil.removeContext(retweetedStatus.getUser().getName())).append("\u3055\u3093\u304b\u3089\u3001");
                buffer.append(retweetedStatus.getText());
            } else {
                buffer.append(DisplayNameUtil.removeContext(status.getUser().getName())).append("\u3055\u3093\u304b\u3089\u3001");
                buffer.append(status.getText());
            }
            this.mTalker.talkAlternatelyAsync(UrlUtil.convURLEmpty(buffer).replaceAll("\n", "\u3002"));
        }
    }
}

