/*
 * Decompiled with CFR 0.152.
 */
package com.mizo0203.timeline.talker;

import com.mizo0203.timeline.talker.Talker;
import com.mizo0203.timeline.talker.TimelineTalker;
import com.mizo0203.timeline.talker.util.DisplayNameUtil;
import com.mizo0203.timeline.talker.util.HTMLParser;
import com.mizo0203.timeline.talker.util.UrlUtil;
import com.sys1yagi.mastodon4j.MastodonClient;
import com.sys1yagi.mastodon4j.api.Handler;
import com.sys1yagi.mastodon4j.api.entity.Account;
import com.sys1yagi.mastodon4j.api.entity.Notification;
import com.sys1yagi.mastodon4j.api.entity.Status;
import com.sys1yagi.mastodon4j.api.method.Streaming;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class MastodonTimelineTalker
implements TimelineTalker {
    @NotNull
    private final Streaming mStreaming;
    @NotNull
    private final OnStatusEvent mOnStatusEvent;

    MastodonTimelineTalker(MastodonClient client, Talker talker) {
        this.mStreaming = new Streaming(client);
        this.mOnStatusEvent = new OnStatusEvent(talker);
    }

    @Override
    public void start() {
        try {
            this.mStreaming.user(this.mOnStatusEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class OnStatusEvent
    implements Handler {
        private final Talker mTalker;

        private OnStatusEvent(Talker talker) {
            this.mTalker = talker;
        }

        @Override
        public void onStatus(@NotNull Status status) {
            if (status == null) {
                OnStatusEvent.$$$reportNull$$$0(0);
            }
            try {
                StringBuffer buffer = new StringBuffer();
                Status reblogStatus = status.getReblog();
                String displayName = "\u8ab0\u304b";
                if (status.getAccount() != null) {
                    displayName = status.getAccount().getDisplayName();
                }
                if (reblogStatus != null) {
                    String reblogDisplayName = "\u8ab0\u304b";
                    if (status.getAccount() != null) {
                        displayName = status.getAccount().getDisplayName();
                    }
                    buffer.append(DisplayNameUtil.removeContext(displayName)).append("\u3055\u3093\u304c\u30d6\u30fc\u30b9\u30c8\u3002");
                    buffer.append(DisplayNameUtil.removeContext(reblogDisplayName)).append("\u3055\u3093\u304b\u3089\u3001");
                    buffer.append(new HTMLParser().parse(reblogStatus.getContent(), StandardCharsets.UTF_8, true));
                } else {
                    buffer.append(DisplayNameUtil.removeContext(displayName)).append("\u3055\u3093\u304b\u3089\u3001");
                    buffer.append(new HTMLParser().parse(status.getContent(), StandardCharsets.UTF_8, true));
                }
                String talkText = UrlUtil.convURLEmpty(buffer).replaceAll("\n", "\u3002");
                this.mTalker.talkAlternatelyAsync(talkText);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onNotification(@NotNull Notification notification) {
            if (notification == null) {
                OnStatusEvent.$$$reportNull$$$0(1);
            }
            StringBuilder buffer = new StringBuilder();
            Account account = notification.getAccount();
            if (account == null) {
                return;
            }
            switch (notification.getType()) {
                case "mention": {
                    buffer.append(DisplayNameUtil.removeContext(account.getDisplayName())).append("\u3055\u3093\u304c\u3042\u306a\u305f\u3092\u30e1\u30f3\u30b7\u30e7\u30f3\u3057\u307e\u3057\u305f\u3002");
                    break;
                }
                case "reblog": {
                    buffer.append(DisplayNameUtil.removeContext(account.getDisplayName())).append("\u3055\u3093\u304c\u3042\u306a\u305f\u306e\u30c8\u30a5\u30fc\u30c8\u3092\u30d6\u30fc\u30b9\u30c8\u3057\u307e\u3057\u305f\u3002");
                    break;
                }
                case "favourite": {
                    buffer.append(DisplayNameUtil.removeContext(account.getDisplayName())).append("\u3055\u3093\u304c\u3042\u306a\u305f\u306e\u30c8\u30a5\u30fc\u30c8\u3092\u304a\u6c17\u306b\u5165\u308a\u306b\u767b\u9332\u3057\u307e\u3057\u305f\u3002");
                    break;
                }
                case "follow": {
                    buffer.append(DisplayNameUtil.removeContext(account.getDisplayName())).append("\u3055\u3093\u306b\u30d5\u30a9\u30ed\u30fc\u3055\u308c\u307e\u3057\u305f\u3002");
                    break;
                }
                default: {
                    return;
                }
            }
            String talkText = buffer.toString();
            this.mTalker.talkAlternatelyAsync(talkText);
        }

        @Override
        public void onDelete(long id) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/mizo0203/timeline/talker/MastodonTimelineTalker$OnStatusEvent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onStatus";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onNotification";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

