/*
 * Decompiled with CFR 0.152.
 */
package com.mizo0203.timeline.talker;

import com.google.gson.Gson;
import com.sys1yagi.mastodon4j.MastodonClient;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

class Arguments {
    @Nullable
    final Configuration twitterConfiguration;
    @Nullable
    final MastodonClient mastodonClient;

    Arguments(String[] args) throws IllegalArgumentException {
        if (args.length == Argument.values().length) {
            this.twitterConfiguration = Arguments.createTwitterConfiguration(args[Argument.TWITTER_CONSUMER_KEY.ordinal()], args[Argument.TWITTER_CONSUMER_SECRET.ordinal()], args[Argument.TWITTER_ACCESS_TOKEN.ordinal()], args[Argument.TWITTER_ACCESS_TOKEN_SECRET.ordinal()]);
            this.mastodonClient = Arguments.createMastodonClient(args[Argument.MASTODON_INSTANCE_NAME.ordinal()], args[Argument.MASTODON_ACCESS_TOKEN.ordinal()]);
        } else if (args.length == Argument.Twitter.values().length) {
            this.twitterConfiguration = Arguments.createTwitterConfiguration(args[Argument.Twitter.CONSUMER_KEY.ordinal()], args[Argument.Twitter.CONSUMER_SECRET.ordinal()], args[Argument.Twitter.ACCESS_TOKEN.ordinal()], args[Argument.Twitter.ACCESS_TOKEN_SECRET.ordinal()]);
            this.mastodonClient = null;
        } else if (args.length == Argument.Mastodon.values().length) {
            this.twitterConfiguration = null;
            this.mastodonClient = Arguments.createMastodonClient(args[Argument.Mastodon.INSTANCE_NAME.ordinal()], args[Argument.Mastodon.ACCESS_TOKEN.ordinal()]);
        } else {
            throw Arguments.createIllegalArgumentException();
        }
    }

    private static Configuration createTwitterConfiguration(String twitterConsumerKey, String twitterConsumerSecret, String twitterAccessToken, String twitterAccessTokenSecret) {
        return new ConfigurationBuilder().setOAuthConsumerKey(twitterConsumerKey).setOAuthConsumerSecret(twitterConsumerSecret).setOAuthAccessToken(twitterAccessToken).setOAuthAccessTokenSecret(twitterAccessTokenSecret).build();
    }

    private static MastodonClient createMastodonClient(String mastodonInstanceName, String mastodonAccessToken) {
        return new MastodonClient.Builder(mastodonInstanceName, new OkHttpClient.Builder(), new Gson()).accessToken(mastodonAccessToken).useStreamingApi().build();
    }

    private static IllegalArgumentException createIllegalArgumentException() {
        return new IllegalArgumentException(Argument.createExceptionMessage() + "\n" + Argument.Twitter.createExceptionMessage() + "\n" + Argument.Mastodon.createExceptionMessage());
    }

    private static enum Argument {
        TWITTER_CONSUMER_KEY,
        TWITTER_CONSUMER_SECRET,
        TWITTER_ACCESS_TOKEN,
        TWITTER_ACCESS_TOKEN_SECRET,
        MASTODON_INSTANCE_NAME,
        MASTODON_ACCESS_TOKEN;


        @NotNull
        private static String createExceptionMessage() {
            StringBuilder exceptionMessage = new StringBuilder("Twitter \u3068 Mastodon \u306e\u4e21\u65b9\u3092\u8aad\u307f\u4e0a\u3052\u308b\u5834\u5408\u3001 ").append(Argument.values().length).append(" \u3064\u306e\u5f15\u6570\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
            for (Argument arg : Argument.values()) {
                exceptionMessage.append(arg.ordinal() + 1).append(" \u3064\u76ee: ").append(arg.getDetail()).append("\n");
            }
            String string = exceptionMessage.toString();
            if (string == null) {
                Argument.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        private String getDetail() throws IllegalStateException {
            switch (this) {
                case TWITTER_CONSUMER_KEY: {
                    if ("Twitter Application's Consumer Key (API Key)" == null) {
                        Argument.$$$reportNull$$$0(1);
                    }
                    return "Twitter Application's Consumer Key (API Key)";
                }
                case TWITTER_CONSUMER_SECRET: {
                    if ("Twitter Application's Consumer Secret (API Secret)" == null) {
                        Argument.$$$reportNull$$$0(2);
                    }
                    return "Twitter Application's Consumer Secret (API Secret)";
                }
                case TWITTER_ACCESS_TOKEN: {
                    if ("Twitter Account's Access Token" == null) {
                        Argument.$$$reportNull$$$0(3);
                    }
                    return "Twitter Account's Access Token";
                }
                case TWITTER_ACCESS_TOKEN_SECRET: {
                    if ("Twitter Account's Access Token Secret" == null) {
                        Argument.$$$reportNull$$$0(4);
                    }
                    return "Twitter Account's Access Token Secret";
                }
                case MASTODON_INSTANCE_NAME: {
                    if ("Mastodon Instance Name" == null) {
                        Argument.$$$reportNull$$$0(5);
                    }
                    return "Mastodon Instance Name";
                }
                case MASTODON_ACCESS_TOKEN: {
                    if ("Mastodon Account's Access Token" == null) {
                        Argument.$$$reportNull$$$0(6);
                    }
                    return "Mastodon Account's Access Token";
                }
            }
            throw new IllegalStateException("getDetail this: " + (Object)((Object)this));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/mizo0203/timeline/talker/Arguments$Argument";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createExceptionMessage";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDetail";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        private static enum Mastodon {
            INSTANCE_NAME,
            ACCESS_TOKEN;


            @NotNull
            private static String createExceptionMessage() {
                StringBuilder exceptionMessage = new StringBuilder("Mastodon \u306e\u307f\u3092\u8aad\u307f\u4e0a\u3052\u308b\u5834\u5408\u3001 ").append(Mastodon.values().length).append(" \u3064\u306e\u5f15\u6570\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
                for (Mastodon arg : Mastodon.values()) {
                    exceptionMessage.append(arg.ordinal() + 1).append(" \u3064\u76ee: ").append(arg.getDetail()).append("\n");
                }
                String string = exceptionMessage.toString();
                if (string == null) {
                    Mastodon.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            private String getDetail() throws IllegalStateException {
                switch (this) {
                    case INSTANCE_NAME: {
                        String string = MASTODON_INSTANCE_NAME.getDetail();
                        if (string == null) {
                            Mastodon.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    case ACCESS_TOKEN: {
                        String string = MASTODON_ACCESS_TOKEN.getDetail();
                        if (string == null) {
                            Mastodon.$$$reportNull$$$0(2);
                        }
                        return string;
                    }
                }
                throw new IllegalStateException("getDetail this: " + (Object)((Object)this));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/mizo0203/timeline/talker/Arguments$Argument$Mastodon";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createExceptionMessage";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDetail";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        private static enum Twitter {
            CONSUMER_KEY,
            CONSUMER_SECRET,
            ACCESS_TOKEN,
            ACCESS_TOKEN_SECRET;


            @NotNull
            private static String createExceptionMessage() {
                StringBuilder exceptionMessage = new StringBuilder("Twitter \u306e\u307f\u3092\u8aad\u307f\u4e0a\u3052\u308b\u5834\u5408\u3001 ").append(Twitter.values().length).append(" \u3064\u306e\u5f15\u6570\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
                for (Twitter arg : Twitter.values()) {
                    exceptionMessage.append(arg.ordinal() + 1).append(" \u3064\u76ee: ").append(arg.getDetail()).append("\n");
                }
                String string = exceptionMessage.toString();
                if (string == null) {
                    Twitter.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            private String getDetail() throws IllegalStateException {
                switch (this) {
                    case CONSUMER_KEY: {
                        String string = TWITTER_CONSUMER_KEY.getDetail();
                        if (string == null) {
                            Twitter.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    case CONSUMER_SECRET: {
                        String string = TWITTER_CONSUMER_SECRET.getDetail();
                        if (string == null) {
                            Twitter.$$$reportNull$$$0(2);
                        }
                        return string;
                    }
                    case ACCESS_TOKEN: {
                        String string = TWITTER_ACCESS_TOKEN.getDetail();
                        if (string == null) {
                            Twitter.$$$reportNull$$$0(3);
                        }
                        return string;
                    }
                    case ACCESS_TOKEN_SECRET: {
                        String string = TWITTER_ACCESS_TOKEN_SECRET.getDetail();
                        if (string == null) {
                            Twitter.$$$reportNull$$$0(4);
                        }
                        return string;
                    }
                }
                throw new IllegalStateException("getDetail this: " + (Object)((Object)this));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/mizo0203/timeline/talker/Arguments$Argument$Twitter";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createExceptionMessage";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDetail";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }
}

