/*
 * Decompiled with CFR 0.152.
 */
package com.mizo0203.twitter.timeline.talker;

import com.mizo0203.twitter.timeline.talker.Talker;
import com.mizo0203.twitter.timeline.talker.UrlUtil;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.conf.Configuration;

public class TwitterTimelineTalker {
    public static final String LANG_JA = Locale.JAPAN.getLanguage();
    private Talker.YukkuriVoice mYukkuriVoice = Talker.YukkuriVoice.REIMU;
    private final TwitterStream mTwitterStream;
    private final Talker mTalker;

    public TwitterTimelineTalker(Configuration configuration, Talker talker) {
        this.mTwitterStream = new TwitterStreamFactory(configuration).getInstance();
        this.mTwitterStream.addListener(new OnStatusEvent());
        this.mTalker = talker;
    }

    public void start() {
        this.mTwitterStream.user();
    }

    private static String getUserNameWithoutContext(String name) {
        Pattern p = Pattern.compile("([^@\uff20]+).+");
        Matcher m = p.matcher(name);
        return m.replaceFirst("$1");
    }

    private class OnStatusEvent
    implements StatusListener {
        private OnStatusEvent() {
        }

        @Override
        public void onStatus(Status status) {
            if (!LANG_JA.equalsIgnoreCase(status.getLang())) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            if (status.isRetweet()) {
                Status retweetedStatus = status.getRetweetedStatus();
                buffer.append(String.valueOf(TwitterTimelineTalker.getUserNameWithoutContext(status.getUser().getName())) + "\u3055\u3093\u304c\u30ea\u30c4\u30a4\u30fc\u30c8\u3002");
                buffer.append(String.valueOf(TwitterTimelineTalker.getUserNameWithoutContext(retweetedStatus.getUser().getName())) + "\u3055\u3093\u304b\u3089\u3001");
                buffer.append(retweetedStatus.getText());
            } else {
                buffer.append(String.valueOf(TwitterTimelineTalker.getUserNameWithoutContext(status.getUser().getName())) + "\u3055\u3093\u304b\u3089\u3001");
                buffer.append(status.getText());
            }
            TwitterTimelineTalker.this.mTalker.talkAsync(UrlUtil.convURLEmpty(buffer).replaceAll("\n", "\u3002"), TwitterTimelineTalker.this.mYukkuriVoice);
            if (TwitterTimelineTalker.this.mYukkuriVoice == Talker.YukkuriVoice.REIMU) {
                TwitterTimelineTalker.this.mYukkuriVoice = Talker.YukkuriVoice.MARISA;
            } else {
                TwitterTimelineTalker.this.mYukkuriVoice = Talker.YukkuriVoice.REIMU;
            }
        }

        @Override
        public void onDeletionNotice(StatusDeletionNotice sdn) {
            System.err.println("onDeletionNotice.");
        }

        @Override
        public void onTrackLimitationNotice(int i) {
            System.err.println("onTrackLimitationNotice.(" + i + ")");
        }

        @Override
        public void onScrubGeo(long lat, long lng) {
            System.err.println("onScrubGeo.(" + lat + ", " + lng + ")");
        }

        @Override
        public void onException(Exception excptn) {
            System.err.println("onException.");
        }

        @Override
        public void onStallWarning(StallWarning arg0) {
        }
    }
}

